# File Injector

A tool for injecting text and prompts into PDF and image files through a highly customizable CLI or UI interface.

## Table of Contents
- [Features](#features)
- [Installation](#installation)
- [Project Structure](#project-structure)
- [Usage](#usage)

## Features

- Support for both PDF and image file injection
- CLI and UI Interface options
- Configurable text properties (font, size, color)
- Multiple injection methods for images (blend/color)
- Support for custom prompts
- Ready custom prompts available

## Installation
To get started with this project, follow these steps:

1. Navigate to the project directory
    ```bash
    cd file_injector

2. Create a virtual environment (Optional)
    ```bash
    python -m venv venv
    ```

3. Activate the virtual environment (Optional)

    If Linux/Unix Systems:
    ```bash
    source venv/bin/activate
    ```
    If Windows system
    ```bash
    venv\Scripts\activate
    ```

4. Install the dependencies
    ```bash
    pip install -r requirements.txt
    ```

## Project Structure

```
file_injector/
├── src/
│   ├── Injector/
│   │   ├── img_injector.py     # Image injector class
│   │   └── pdf_injector.py     # PDF injector class           
│   └── utils.py                # Utility functions
├── Prompts/                    # Sample prompt files
├── config.yaml                 # Default configuration
├── main.py                     # CLI interface
├── ui.py                       # UI interface
└── requirements.txt
```

## Usage

### UI Usage

```bash
streamlit run ui.py
```

### CLI Usage

```bash
# Image injection with blending
python main.py --mode "img" --file <image_file_path> --prompt_file <prompt_file_path> --output_file <output_file_path> --method "blend"

# Image injection with custom color
python main.py --mode "img" --file <image_file_path> --prompt_file <prompt_file_path> --output_file <output_file_path>  --method "color" --color <color>

# PDF injection
python main.py --mode "pdf" --file <pdf_file_path> --prompt_file <prompt_file_path> --output_file <output_file_path>  
```

### CLI Arguments

#### Common Arguments
- `--config_file`: Path to config file (default: config.yaml)
- `--mode`: File type to process [pdf|img]
- `--file`: Input file path
- `--prompt_file`: Text file containing prompt
- `--output_file`: Output file path
- `--num_times`: Number of times to repeat prompt

#### Image Mode Arguments
- `--image_mode`: Image mode [RGB|L]
- `--font_size`: Font size for text
- `--method`: Injection method [blend|color]
- `--color`: Text color (when method="color")
