'''
footprintLambda - Lambda Function footprinting Script
(c) Blueinfy solutions pvt. ltd.
This is beta version of the toolkit and it is in the development
phase.
==============================================================
'''

import argparse
import boto3, time, json

parser = argparse.ArgumentParser()

print('\n==============================================================')
print('footprintLambda - Lambda Function Footprinting Script (beta)')
print('(c) Blueinfy solutions pvt. ltd.')
print('==============================================================\n')


parser.add_argument('-p', action='store_true', dest='function', default=False,
                    help='use for footprint and mapping')


results = parser.parse_args()


if(results.function==False):
	print(parser.parse_args(['-h']))

lmclient = boto3.client('lambda')
sqsclient = boto3.client('sqs')
s3client = boto3.client('s3')
dbclient = boto3.client('dynamodb')
resultList = []



print("(+) Collecting list of Lambda functions for footprinting...")
listFunctionResponse = lmclient.list_functions()
for key, value in listFunctionResponse.items():
	if(key == 'Functions'):
		for fnvalue in value:
			print("	(-)Lambda: {} - {}".format(fnvalue['FunctionName'], fnvalue['FunctionArn']))
			resultObject = {}
			resultObject['FunctionName'] = str(fnvalue['FunctionName'])
			resultObject['FunctionArn'] = str(fnvalue['FunctionArn'])
			resultObject['EventSourceArn'] = ""
			resultList.append(resultObject)

print("\n(+) Collecting list of EventSourceMappings for footprinting...")

listEvnetSource = lmclient.list_event_source_mappings()
for key, value in listEvnetSource.items():
	if(key == 'EventSourceMappings'):
		for fnvalue in value:
			print(" (-)EventSource: {} - {}".format(fnvalue['EventSourceArn'], fnvalue['FunctionArn']))
			for result in resultList:
				if(result['FunctionArn'] == fnvalue['FunctionArn']):
					result['EventSourceArn'] = str(fnvalue['EventSourceArn'])



print("\n(+) Collecting list of configured SQS for footprinting...")

listSQS = sqsclient.list_queues()
for key, value in listSQS.items():
	if(key == 'QueueUrls'):
		for fnvalue in value:
			print(" (-) Queue: {}" . format(fnvalue))
			print(" (-) Collecting queue information for {} ...".format(fnvalue))
			qurlresponse = sqsclient.get_queue_attributes(QueueUrl=fnvalue, AttributeNames=['All'])	
			print(" (-)",qurlresponse)
			

print("\n(+) Collecting list of configured S3 for footprinting...")

listBucket = s3client.list_buckets()
for key, value in listBucket.items():
	if(key == 'Buckets'):
		for fnvalue in value:
			print("	(-)Bucket: {} - {}".format(fnvalue['Name'], fnvalue['CreationDate']))
			bucketName = str(fnvalue['Name'])
			print("	(-)Collecting bucket notification information for {} ...".format(bucketName))
			
			responseNotification = s3client.get_bucket_notification(Bucket=bucketName)
			print("	(-)",responseNotification)
			for rkey, rvalue in responseNotification.items():
				if(rkey == 'CloudFunctionConfiguration'):
					for result in resultList:
						if(result['FunctionArn'] == rvalue['CloudFunction']):
							result['EventSourceArn'] = str("S3 - " + bucketName)					



print("\n(+) Collecting list of configured Dynamodb tables for footprinting...")

listTable = dbclient.list_tables()
for key, value in listTable.items():
	if(key == 'TableNames'):
		for fnvalue in value:
			print("	(-) Table: {}".format(fnvalue))
			print("	(-) Collecting table information for {} ...".format(fnvalue))
		
			responseNotification = dbclient.describe_table(TableName=fnvalue)
			print(responseNotification)			

print("\n(+) ==> Final Footprint and Mapping Results...")
for result in resultList:
	print("	(-){} ({}) - {}".format(result['FunctionName'], result['FunctionArn'], result['EventSourceArn']))

	
