# Ajax fingerprinting script using local database (ajaxfinger-db)
# Author: Shreeraj Shah (shreeraj.shah@gmail.com)

require 'open-uri'
require 'rexml/document'
include REXML

if (ARGV.length != 1)
  puts "\nUsage:\n"
  puts "ajaxfinger.rb <Target URL>\n"
  puts "Example:\n"  
  puts "ajaxfinger.rb http://digg.com\n"  
  Kernel.exit(1)
end

url = ARGV[0]
html = open(url)
page = html.read
all_path = ""

puts "\n---Scanning for scripts---"
a_script=page.scan(/<script.*?>/)
a_script.each do |temp|
  if(temp.scan("src").length > 0)
    temp += "</script>"
    doc=Document.new temp 
    root = doc.root
    all_path += root.attributes["src"]+"|"
    puts root.attributes["src"]
  end
end

puts "\n---Fingerprinting Ajax frameworks---"
File.open("ajaxfinger-db",'r') do |temp|
  while line = temp.gets
    if not (/^#/.match(line))
      if(all_path.scan(line.chomp).length>0)
        puts "[+]  "+line.chomp + " [..Found..]"
      end
    else
      puts line
    end
  end
end