# Flash fingerprinting script 
# Author: Shreeraj Shah (shreeraj@blueinfy.com)

require 'open-uri'
require 'rexml/document'
include REXML

if (ARGV.length != 1)
  puts "\nUsage:\n"
  puts "flashfinger.rb <Target URL>\n"
  puts "Example:\n"  
  puts "flashfinger.rb http://example.com\n"  
  Kernel.exit(1)
end

url = ARGV[0]
html = open(url)
page = html.read
all_path = ""
page=page.gsub("\n"," ")

puts "\n---Scanning for flash object---"
reg=Regexp.new(/<object.*?object>/i)
match=reg.match(page)
doc=Document.new match .to_s
root = doc.root

data = root.attributes["data"]
if data != nil
  if data.scan(/swf/i).length > 0
    puts "object-> "+data
  end
    if data.scan(/lzx/i).length > 0
    puts "Laszlo-> "+data
  end
end

doc.elements.each("object/param") do |element|
  if element.attributes["value"] .scan(/swf/i).length > 0
    puts "param-> "+element.attributes["value"] 
  end
    if element.attributes["value"] .scan(/lzx/i).length > 0
    puts "Laszlo-> "+element.attributes["value"] 
  end
end

doc.elements.each("object/embed") do |element|
  if element.attributes["src"] .scan(/swf/i).length > 0
    puts "embed-> "+element.attributes["src"] 
  end
  if element.attributes["src"] .scan(/lzx/i).length > 0
    puts "Laszlo-> "+element.attributes["src"] 
  end
end


